package de.test.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class MyDb extends SQLiteOpenHelper {

	private static final String DB_NAME = "database.db";
	private static final int DB_VERSION = 1;

	public MyDb(Context context) {
		super(context, DB_NAME, null, DB_VERSION);
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE tbl_test ( id INTEGER PRIMARY KEY AUTOINCREMENT, test TEXT NOT NULL )");
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		// if tables do not contain any data, they can be dropped
		// otherwise, they should be altered
		db.execSQL("DROP TABLE IF EXISTS tbl_test");
		onCreate(db);
	}
}